import '../../../core/utils/method.dart';
import '../../../core/utils/url_container.dart';
import '../../model/global/response_model/response_model.dart';
import '../../services/api_client.dart';

class TransactionHistoryRepo{

  ApiClient apiClient;
  TransactionHistoryRepo({required this.apiClient});

  Future<ResponseModel> getTransactionData({String type = "", String remark = "", String searchText = ""}) async {

    if(type.toLowerCase() == "all" || (type.toLowerCase()!='plus'&&type.toLowerCase()!='minus')){
      type='';
    }

    if(remark.isEmpty || remark.toLowerCase() == "any"){
      remark = '';
    }

    String url = "${UrlContainer.baseUrl}${UrlContainer.transactionEndpoint}?type=$type&remark=$remark&search=$searchText";
    ResponseModel responseModel = await apiClient.request(url, Method.getMethod, null, passHeader: true);
    return responseModel;
  }

}